using System;
using System.Collections.Generic;
using System.Text;

namespace Intemi.InTrees.Implements
{
    public class MinNodeSizeSC : IStoppingCriterion
    {
        private NaturalStoppingCriterium naturalSC = new NaturalStoppingCriterium();
        private int minNodeSize;

        public MinNodeSizeSC(int minNodeSize)
        {
            this.minNodeSize = minNodeSize;
        }

        public bool Stop(IDataTable dataTable, ref bool shouldTerminate)
        {
            bool stop = naturalSC.Stop(dataTable, ref shouldTerminate);
            if(!stop)
              stop = (dataTable.InstanceCount < minNodeSize);
            return (stop);
        }

        public bool Stop(IDataTable dataTable, List<INodeTest> nodeTests, ref bool shouldTerminate)
        {
            bool stop = naturalSC.Stop(dataTable, nodeTests,ref shouldTerminate);
            if (!stop)
                stop = (dataTable.InstanceCount < minNodeSize);
            return (stop);
        }
    }
}
